package inc.monsters.mias.backing;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;

import javax.faces.context.FacesContext;

import org.apache.myfaces.trinidad.context.RequestContext;

public class BravenessCalc {
	private static Logger log = Logger.getLogger("inc.monsters.mias");
	private List<KidsReaction> childReactions;
	private int selectedReaction;
	private int age;
	private double braveness;
	
	public BravenessCalc() {
		childReactions = new ArrayList<KidsReaction>();
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getMessageBundle();
		ResourceBundle msg = ResourceBundle.getBundle(context.getApplication().getMessageBundle());
		int i = 0;
		childReactions.add(new KidsReaction(i++, msg.getString("jump")));  // Jumps out of bed and runs to the parent's room.
		childReactions.add(new KidsReaction(i++, msg.getString("cry")));   // Starts to cry for it's mother.
		childReactions.add(new KidsReaction(i++, msg.getString("hides"))); // Hides head under the pillow.
		childReactions.add(new KidsReaction(i++, msg.getString("kill")));  // Tries to kill the monster with a super soaker.
		childReactions.add(new KidsReaction(i++, msg.getString("hello"))); // Says "hello" and starts a nice chat. 
		childReactions.add(new KidsReaction(i++, msg.getString("game")));  // Asks if the monster is in for a game of hide and seek.
		childReactions.add(new KidsReaction(i++, msg.getString("yell")));  // Starts to yell: "How dare you entering my room without knocking! Go away!"
	}

	public List<KidsReaction> getChildReactions() {
		return childReactions;
	}

	public void setChildReactions(List<KidsReaction> childReactions) {
		this.childReactions = childReactions;
	}

	public int getSelectedReaction() {
		return selectedReaction;
	}

	public void setSelectedReaction(int selectedReaction) {
		this.selectedReaction = selectedReaction;
	}

	public int getAge() {
		RequestContext requestContext = RequestContext.getCurrentInstance();
		age = (Integer)requestContext.getPageFlowScope().get("kidsAge");
		return age;
	}

	public double getBraveness() {
		braveness = ((12.0 - (double)getAge()) * (10.0/12.0) * ((double)getSelectedReaction() + 1.0) * (10.0 / (double)childReactions.size()))/10.0;
		return braveness;
	}
	
    public String done() {
    	log.fine("done() called, braveness = " + getBraveness());
    	RequestContext.getCurrentInstance().returnFromDialog(getBraveness(), null);
    	return null;
    }
}
